<?php
/**
 * Plus customizer section.
 */
if(!class_exists('Screenr_Customize_Section_Plus')):
class Screenr_Customize_Section_Plus extends WP_Customize_Section {

	/**
	 * The type of customize section being rendered.
	 *
	 * @since  1.0.0
	 * @access public
	 * @var    string
	 */
	public $type = 'upgrade-plus';

	/**
	 * Custom button text to output.
	 *
	 * @since  1.0.0
	 * @access public
	 * @var    string
	 */
	public $plus_text = '';

	/**
	 * Custom pro button URL.
	 *
	 * @since  1.0.0
	 * @access public
	 * @var    string
	 */
	public $plus_url = '';

	/**
	 * Add custom parameters to pass to the JS via JSON.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function json() {
		$json = parent::json();

		$json['plus_text'] = $this->plus_text;
		$json['plus_url']  = esc_url( $this->plus_url );

		return $json;
	}

	/**
	 * Outputs the Underscore.js template.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	protected function render_template() { ?>

		<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }}">
			<h3 class="accordion-section-title">
				{{ data.title }}
				<# if ( data.plus_text && data.plus_url ) { #>
					<a href="{{ data.plus_url }}" class="" target="_blank">{{ data.plus_text }} &rarr;</a>
				<# } #>
			</h3>
		</li>
	<?php }
}
endif;
