<?php

/**
 * Custom functions that act independently of the theme templates
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 */

/**
 * Disable Redux Demo Mode
 */
function parallel_disable_redux_demo() {
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action('init', 'parallel_disable_redux_demo');

/**
 * Remove Redux Menu Under Tools
 */
add_action( 'admin_menu', 'parallel_remove_redux_menu',12 );
function parallel_remove_redux_menu() {
    remove_submenu_page('tools.php','redux-about');
}

/**
 * Filter the except length.
 *
 * @param int $length Excerpt length.
 * @return int (Maybe) modified excerpt length.
 */
function parallel_custom_excerpt_length( $length ) {
    if ( is_admin() ) {
        return $length;
    }
    return 27;
}
add_filter( 'excerpt_length', 'parallel_custom_excerpt_length', 999 );

/**
 * Add Bootstrap img-responsive to all content images
 */
function parallel_add_image_responsive_class($content) {
   global $post;
   $pattern ="/<img(.*?)class=\"(.*?)\"(.*?)>/i";
   $replacement = '<img$1class="$2 img-responsive"$3>';
   $content = preg_replace($pattern, $replacement, $content);
   return $content;
}
add_filter('the_content', 'parallel_add_image_responsive_class');

/**
 * Handles JavaScript detection.
 * Adds a js class to the root <html> element when JavaScript is detected.
 */
function parallel_javascript_detection() {
  echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'parallel_javascript_detection', 0 );

/**
 * Handles Redux Gallery
 */
function parallel_wp_get_attachment( $attachment_id ) {
    $attachment = get_post( $attachment_id );
    return array(
        'alt' => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),
        'caption' => $attachment->post_excerpt,
        'description' => $attachment->post_content,
        'href' => get_permalink( $attachment->ID ),
        'src' => $attachment->guid,
        'title' => $attachment->post_title
    );
}